/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.placement;

import com.google.common.collect.ImmutableList;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.placement.AbstractBlueprintIterator;
import com.ldtteam.structurize.placement.BlueprintIteratorDefault;
import com.ldtteam.structurize.placement.BlueprintIteratorHilbert;
import com.ldtteam.structurize.placement.BlueprintIteratorInwardCircle;
import com.ldtteam.structurize.placement.BlueprintIteratorInwardCircleHeight;
import com.ldtteam.structurize.placement.BlueprintIteratorRandom;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class StructureIterators {
    private static final Map<String, Function<IStructureHandler, AbstractBlueprintIterator>> iteratorProducers = new HashMap<String, Function<IStructureHandler, AbstractBlueprintIterator>>();

    public static void registerIterator(String id, Function<IStructureHandler, AbstractBlueprintIterator> producer) {
        iteratorProducers.put(id, producer);
    }

    public static List<String> getKeySet() {
        return ImmutableList.copyOf(iteratorProducers.keySet());
    }

    public static AbstractBlueprintIterator getIterator(String id, IStructureHandler handler) {
        Function<IStructureHandler, AbstractBlueprintIterator> iterator = iteratorProducers.get(id);
        if (iterator == null) {
            Log.getLogger().warn("Could not find iterator for value:" + id + " using default instead!");
            return new BlueprintIteratorDefault(handler);
        }
        return iterator.apply(handler);
    }

    static {
        iteratorProducers.put("default", BlueprintIteratorDefault::new);
        iteratorProducers.put("inwardcircle", BlueprintIteratorInwardCircle::new);
        iteratorProducers.put("inwardcircleheight1", handler -> new BlueprintIteratorInwardCircleHeight((IStructureHandler)handler, 1));
        iteratorProducers.put("inwardcircleheight2", handler -> new BlueprintIteratorInwardCircleHeight((IStructureHandler)handler, 2));
        iteratorProducers.put("inwardcircleheight3", handler -> new BlueprintIteratorInwardCircleHeight((IStructureHandler)handler, 3));
        iteratorProducers.put("inwardcircleheight4", handler -> new BlueprintIteratorInwardCircleHeight((IStructureHandler)handler, 4));
        iteratorProducers.put("hilbert", BlueprintIteratorHilbert::new);
        iteratorProducers.put("random", BlueprintIteratorRandom::new);
    }
}

